%--------------------------------------------------------------------------
% File     : GRP002=O3CmtrEqId-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Commutator equals identity in groups of order 3
% Version  : [Overbeek, 1990] (equality) axioms : Incomplete.
% English  : In a group, if (for all x) the cube of x is the identity 
%            (i.e. a group of order 3), then the equation [[x,y],y]= 
%            identity holds, where [x,y] is the product of x, y, the 
%            inverse of x and the inverse of y (i.e. the commutator 
%            of x and y).

% Refs     : Overbeek R. (1990), ATP competition announced at CADE-10.
%          : Overbeek R. (1993), The CADE-11 Competitions: A Personal 
%            View, Journal of Automated Reasoning 11(3), 315-316.
%          : Lusk E.L., McCune W.W. (1993), Uniform Strategies: The 
%            CADE-11 Theorem Proving Contest, Journal of Automated 
%            Reasoning 11(3), 317-331.
%          : Zhang H. (1993), Automated Proofs of Equality Problems 
%            in Overbeek's Competition, Journal of Automated Reasoning 
%            11(3), 333-351.
% Source   : [Overbeek, 1990]
% Names    : Overbeek Competition Eq-1 [Overbeek, 1990]

% Status   : 
% Syntax   : Number of clauses           :   14 (   0 non-Horn)(   7 unit)
%            Number of literals          :   22 (  22 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   3 constant)
%            Number of variables         :   28 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : Uses an explicit formulation of the commutator.
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%----Substitution axioms 
input_clause(inverse_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(inverse(A),inverse(B))]).

input_clause(multiply_substitutivity1,axiom,
    [--equal(C,D),
     ++equal(multiply(C,E),multiply(D,E))]).

input_clause(multiply_substitutivity2,axiom,
    [--equal(F,G),
     ++equal(multiply(H,F),multiply(H,G))]).

%----For any x and y in the group x*y is also in the group. No clause 
%----is needed here since this is an instance of reflexivity 

%----There exists an identity element 'e' defined below.
input_clause(left_identity,axiom,
    [++equal(multiply(identity,X),X)]).

% input_clause(right_identity,axiom,
%     [++equal(multiply(X,identity),X)]).

%----For any x in the group, there exists an element y such that x*y = y*x 
%----= e.
input_clause(left_inverse,axiom,
    [++equal(multiply(inverse(X),X),identity)]).

% input_clause(right_inverse,axiom,
%     [++equal(multiply(X,inverse(X)),identity)]).

%----The operation '*' is associative 
input_clause(associativity,axiom,
    [++equal(multiply(multiply(X,Y),Z),multiply(X,multiply(Y,Z)))]).

%----Definition of the commutator 
input_clause(commutator,axiom,
    [++equal(commutator(X,Y),multiply(X,multiply(Y,multiply(inverse(X),
inverse(Y)))))]).

input_clause(commutator_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(commutator(A,C),commutator(B,C))]).

input_clause(commutator_substitutivity2,axiom,
    [--equal(D,E),
     ++equal(commutator(F,D),commutator(F,E))]).

input_clause(x_cubed_is_identity,hypothesis,
    [++equal(multiply(X,multiply(X,X)),identity)]).

input_clause(prove_commutator,theorem,
    [--equal(commutator(commutator(a,b),b),identity)]).
%--------------------------------------------------------------------------
