%--------------------------------------------------------------------------
% File     : GRP002=O3CmtrEqId-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Commutator equals identity in groups of order 3
% Version  : [McCharen, et al., 1976] (equality) axioms.
% English  : In a group, if (for all x) the cube of x is the identity 
%            (i.e. a group of order 3), then the equation [[x,y],y]= 
%            identity holds, where [x,y] is the product of x, y, the 
%            inverse of x and the inverse of y (i.e. the commutator 
%            of x and y).

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : commutator.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   18 (   0 non-Horn)(  13 unit)
%            Number of literals          :   24 (  24 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   11 (   8 constant)
%            Number of variables         :   22 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include the equality axioms for this formulation 
include('Axioms/GRP004-0.ax').
%--------------------------------------------------------------------------
%----This hypothesis is omitted in the ANL source version 
input_clause(x_cubed_is_identity,hypothesis,
    [++equal(multiply(X,mulitply(X,X)),identity)]).

input_clause(a_times_b_is_c,theorem,
    [++equal(multiply(a,b),c)]).

input_clause(c_times_inverse_a_is_d,theorem,
    [++equal(multiply(c,inverse(a)),d)]).

input_clause(d_times_inverse_b_is_h,theorem,
    [++equal(multiply(d,inverse(b)),h)]).

input_clause(h_times_b_is_j,theorem,
    [++equal(multiply(h,b),j)]).

input_clause(j_times_inverse_h_is_k,theorem,
    [++equal(multiply(j,inverse(h)),k)]).

input_clause(prove_k_times_inverse_b_is_e,theorem,
    [--equal(multiply(k,inverse(b)),identity)]).
%--------------------------------------------------------------------------
