%--------------------------------------------------------------------------
% File     : GRP002=O3CmtrEqId-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Commutator equals identity in groups of order 3
% Version  : [McCharen, et al., 1976] axioms.
% English  : In a group, if (for all x) the cube of x is the identity 
%            (i.e. a group of order 3), then the equation [[x,y],y]= 
%            identity holds, where [x,y] is the product of x, y, the 
%            inverse of x and the inverse of y (i.e. the commutator 
%            of x and y).

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Overbeek R., McCharen J., and Wos L. (1976), Complexity and 
%            Related Enhancements for Automated Theorem-Proving Programs, 
%            Computer and Mathematics with Applications 2, 1-16.
%          : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
%          : Overbeek R. (1990), ATP competition announced at CADE-10.
%          : Overbeek R. (1993), The CADE-11 Competitions: A Personal 
%            View, Journal of Automated Reasoning 11(3), 315-316.
%          : Lusk E.L., McCune W.W. (1993), Uniform Strategies: The 
%            CADE-11 Theorem Proving Contest, Journal of Automated 
%            Reasoning 11(3), 317-331.
%          : Zhang H. (1993), Automated Proofs of Equality Problems 
%            in Overbeek's Competition, Journal of Automated Reasoning 
%            11(3), 333-351.
% Source   : [McCharen, et al., 1976]
% Names    : G6 [McCharen, et al., 1976]
%          : Theorem 1 [Overbeek, et al., 1976]
%          : Test Problem 2 [Wos, 1988]
%          : The Commutator Theorem [Wos, 1988]
%          : Overbeek Competition 2 [Overbeek, 1990]
%          : commutator.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   25 (   0 non-Horn)(  12 unit)
%            Number of literals          :   47 (  16 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   10 (   8 constant)
%            Number of variables         :   52 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%--------------------------------------------------------------------------
input_clause(x_cubed_is_identity_1,hypothesis,
    [--product(X,X,Y),
     ++product(X,Y,identity)]).

input_clause(x_cubed_is_identity_2,hypothesis,
    [--product(X,X,Y),
     ++product(Y,X,identity)]).

input_clause(a_times_b_is_c,theorem,
    [++product(a,b,c)]).

input_clause(c_times_inverse_a_is_d,theorem,
    [++product(c,inverse(a),d)]).

input_clause(d_times_inverse_b_is_h,theorem,
    [++product(d,inverse(b),h)]).

input_clause(h_times_b_is_j,theorem,
    [++product(h,b,j)]).

input_clause(j_times_inverse_h_is_k,theorem,
    [++product(j,inverse(h),k)]).

input_clause(prove_k_times_inverse_b_is_e,theorem,
    [--product(k,inverse(b),identity)]).
%--------------------------------------------------------------------------
