%--------------------------------------------------------------------------
% File     : GRP001=SqrComm-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : X^2 = identity => commutativity
% Version  : [Chang, 1970] axioms : Incomplete.
% English  : If the square of every element is the identity, the system 
%            is commutative.

% Refs     : Luckham D. (1968), Some Tree-paring Strategies for Theorem 
%            Proving, Michie D. (Ed), Machine Intelligence 3, 95-112.
%          : Loveland D.W. (1969), Theorem-provers Combining Model 
%            Elimination and Resolution, Meltzer B, Michie D. (Eds), 
%            Machine Intelligence 4, 73-86.
%          : Chang C.L. (1970), The Unit Proof and the Input Proof 
%            in Theorm Proving, Communications of the ACM 17(4), 698-707.
%          : Michie D., Ross R. and Shannan G.J. (1972), G-deduction, 
%            Machine Intelligence 7, Edinburgh University Press, 141-165.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [Chang, 1970]
% Names    : Example 4 [Luckham, 1968]
%          : Example 1 [Loveland, 1969]
%          : Chang-Lee-2 [Chang, 1970]
%          : ROB2 [Michie, et al., 1972]
%          : GROUP2 [Wilson & Minker, 1976]
%          : ROB2 [Wilson & Minker, 1976]
%          : EX2 [SPRFN]

% Status   : 
% Syntax   : Number of clauses           :    7 (   0 non-Horn)(   5 unit)
%            Number of literals          :   13 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   4 constant)
%            Number of variables         :   15 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    1

% Comments : In this format it is essentially a monoid problem.
%--------------------------------------------------------------------------
input_clause(left_identity,axiom,
    [++product(identity,X,X)]).

input_clause(right_identity,axiom,
    [++product(X,identity,X)]).

input_clause(associativity1,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(U,Z,W),
     ++product(X,V,W)]).

input_clause(associativity2,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(X,V,W),
     ++product(U,Z,W)]).

input_clause(square_element,hypothesis,
    [++product(X,X,identity)]).

input_clause(a_times_b_is_c,hypothesis,
    [++product(a,b,c)]).

input_clause(prove_b_times_a_is_c,theorem,
    [--product(b,a,c)]).
%--------------------------------------------------------------------------
