%--------------------------------------------------------------------------
% File     : GRP001=SqrComm-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : X^2 = identity => commutativity
% Version  : [Wos, 1965] (equality) axioms : Incomplete.
% English  : If the square of every element is the identity, the system 
%            is commutative.

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 65 [Pelletier, 1986]
%          : x2_quant.in [OTTER]

% Status   : 
% Syntax   : Number of clauses           :   10 (   0 non-Horn)(   6 unit)
%            Number of literals          :   15 (  15 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   4 constant)
%            Number of variables         :   17 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : Pelletier [1986] says "... problems, published I think, 
%            by Larry Wos (but I cannot locate where)."
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(multiply_substitution1,axiom,
    [--equal(D,E),
     ++equal(multiply(D,F),multiply(E,F))]).

input_clause(multiply_substitution2,axiom,
    [--equal(G,H),
     ++equal(multiply(I,G),multiply(I,H))]).

%----The operation '*' is associative 
input_clause(associativity,axiom,
    [++equal(multiply(multiply(X,Y),Z),multiply(X,multiply(Y,Z)))]).

%----There exists an identity element 'e' defined below.
input_clause(left_identity,axiom,
    [++equal(multiply(identity,X),X)]).

input_clause(squareness,hypothesis,
    [++equal(multiply(X,X),identity)]).

input_clause(a_times_b_is_c,hypothesis,
    [++equal(multiply(a,b),c)]).

input_clause(prove_b_times_a_is_c,theorem,
    [--equal(multiply(b,a),c)]).
%--------------------------------------------------------------------------
