%--------------------------------------------------------------------------
% File     : GRP001=SqrComm-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : X^2 = identity => commutativity
% Version  : [Boyer, et al., 1986] axioms.
% English  : If the square of every element is the identity, the system 
%            is commutative.

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3) 87-327.
% Source   : [Boyer, et al., 1986]
% Names    : Problem 228-231 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  328 (  27 non-Horn)(  15 unit)
%            Number of literals          :  781 ( 341 equality)
%            Number of predicate symbols :   19 (   0 propositional)
%            Number of function symbols  :   71 (   9 constant)
%            Number of variables         :  931 (  32 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%----Include the axioms for algebra from Godel's set axioms 
include('Axioms/ALG001-0.ax').
%----Include the equality axioms for algebra from Godel's set axioms 
include('Axioms/ALG001-0.eq').
%--------------------------------------------------------------------------
input_clause(a_group,hypothesis,
    [++group(f71,f72)]).

input_clause(f73_is_the_identity,hypothesis,
    [++identity(f71,f72,f73)]).

input_clause(x_squared_is_identity,hypothesis,
    [--member(X,f71),
     ++equal(apply_to_two_arguments(f72,X,X),f73)]).

input_clause(prove_the_group_is_commutative,theorem,
    [--commutes(f71,f72)]).
%--------------------------------------------------------------------------
