%--------------------------------------------------------------------------
% File     : GRP001=SqrComm-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : X^2 = identity => commutativity
% Version  : [McCharen, et al., 1976] (equality) axioms.
% English  : If the square of every element is the identity, the system 
%            is commutative.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Lusk E., and Overbeek R. (1985), Reasoning about Equality, 
%            Journal of Automated Reasoning 1(2), 209-228.
%          : Lusk E., and Wos L. (1992), Benchmark Problems in Which 
%            Equality Plays the Major Role, In Kapur D. (Ed.), Proceedings 
%            of the 11th International Conference on Automated Deduction 
%            (Saratoga Springs, NY, 1992), (Lecture Notes in Artificial 
%            Intelligence 607), Springer-Verlag, New York, NY, 781-785.
% Source   : [ANL]
% Names    : GP1 [McCharen, et al., 1976]
%          : Problem 1 [Lusk & Overbeek, 1985]
%          : GT1 [Lusk & Wos, 1992]
%          : xsquared.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   14 (   0 non-Horn)(   9 unit)
%            Number of literals          :   20 (  20 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   4 constant)
%            Number of variables         :   22 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include equality group theory axioms 
include('Axioms/GRP004-0.ax').
%--------------------------------------------------------------------------
input_clause(squareness,hypothesis,
    [++equal(multiply(X,X),identity)]).

input_clause(a_times_b_is_c,hypothesis,
    [++equal(multiply(a,b),c)]).

input_clause(prove_b_times_a_is_c,theorem,
    [--equal(multiply(b,a),c)]).
%--------------------------------------------------------------------------
