%--------------------------------------------------------------------------
% File     : GRA001=Labels-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Graph Theory
% Problem  : Clauses from a labelled graph
% Version  : 
% English  : Consider a graph with the edges labelled. For example
%                          *       :
%                      A /   \ B   :
%                       *--C--*    :
%                      D \   / E   :
%                          *       :
%            Assign 0 or 1 arbitarily to nodes of the graph. For each node 
%            of the graph, we associate a set of clauses as follows :
%            (1) Every label of an edge emanating from that node will
%                occur in each clause (of the set of clauses generated
%                from that node).
%            (2) If the node is assigned 0, then the number of negated
%                literals in each of the generated clauses is to be odd.
%                Generate all such clauses for that node.
%            (3) If the node is assigned 1, then the number of negated
%                literals in each of the generated clauses is to be even.
%                Generate all such clauses for that node.
%            Tseitin's result is this: the sum (mod 2) of the 0's and 1's 
%            assigned to the nodes of the graph equals 1 iff the set 
%            of generated clauses is inconsistent. For example, if the top 
%            node of the above graph is assigned 1, and all other nodes 
%            0, then the set of generated clauses will be inconsistent.

% Refs     : Tseitin G.S. (1968), On the Complexity of Derivation 
%            in Propositional Calculus, reprinted in Siekmann J. and 
%            Wrightson G. (Eds), Automation of Reasoning, Springer-Verlag, 
%            Berlin, Germany.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 74 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :   12 (   7 non-Horn)(   0 unit)
%            Number of literals          :   32 (   0 equality)
%            Number of predicate symbols :    5 (   5 propositional)
%            Number of function symbols  :    0 (   0 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    0

% Comments : There is a graph which can be used to produce a problem 
%            equivalent to Pelletier 71. This is described in Pelletier 
%            74.
%--------------------------------------------------------------------------
%----From the top node, which was assigned 1. Therefore there must 
%----be an even number of negated literals.
input_clause(clause_1,theorem,
    [++a,++b]).

input_clause(clause_2,theorem,
    [--a,--b]).

%----From the left node, which was assigned 0. Therefore there must 
%----be an odd number of negated literals.
input_clause(clause_3,theorem,
    [++a,++c,--d]).

input_clause(clause_4,theorem,
    [++a,--c,++d]).

input_clause(clause_5,theorem,
    [--a,++c,++d]).

input_clause(clause_6,theorem,
    [--a,--c,--d]).

%----From the right node, which was assigned 0. Therefore there must 
%----be an odd number of negated literals.
input_clause(clause_7,theorem,
    [++b,++c,--e]).

input_clause(clause_8,theorem,
    [++b,--c,++e]).

input_clause(clause_9,theorem,
    [--b,++c,++e]).

input_clause(clause_10,theorem,
    [--b,--c,--e]).

%----From the bottom node, which was assigned 0. Therefore there must 
%----be an odd number of negated literals.
input_clause(clause_11,theorem,
    [++d,--e]).

input_clause(clause_12,theorem,
    [--d,++e]).
%--------------------------------------------------------------------------
