%--------------------------------------------------------------------------
% File     : GEO079=AltAngleEq-1 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Geometry
% Problem  : The alternate interior angles in a trapezoid are equal
% Version  : [Chang, 1970] axioms : Incomplete.
% English  : The alternate interior angles formed by a diagonal of a (not 
%            necessarily isosceles) trapezoid are equal.

% Refs     : Slagle J.R. (1967), Automatic Theorem Proving With Renamable 
%            Semantic Resolution, Journal of the ACM 14(4), 687-697.
% Source   : [Slagle, 1967]
% Names    : GEOMETRY THEOREM [Slagle, 1967]

% Status   : 
% Syntax   : Number of clauses           :    6 (   0 non-Horn)(   2 unit)
%            Number of literals          :   11 (   0 equality)
%            Number of predicate symbols :    5 (   0 propositional)
%            Number of function symbols  :    4 (   4 constant)
%            Number of variables         :   20 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
input_clause(right_angles_are_equal,axiom,
    [--right_angle(U,V,W),
     --right_angle(X,Y,Z),
     ++eq(U,V,W,X,Y,Z)]).

input_clause(corresponding_angles_are_equal,axiom,
    [--congruent(U,V,W,X,Y,Z),
     ++eq(U,V,W,X,Y,Z)]).

input_clause(trapezoid_definition,axiom,
    [--trapezoid(U,V,W,X),
     ++parallel(V,W,U,X)]).

input_clause(interior_angles_are_equal,axiom,
    [--parallel(U,V,X,Y),
     ++eq(X,V,U,V,X,Y)]).

input_clause(a_trapezoid,hypothesis,
    [++trapezoid(a,b,c,d)]).

input_clause(prove_angles_equal,theorem,
    [--eq(a,c,b,c,a,d)]).
%--------------------------------------------------------------------------
