%--------------------------------------------------------------------------
% File     : GEO078=3PlPtsNotColl-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry (Hilbert)
% Problem  : Every plane contains 3 noncollinear points
% Version  : [Benanav, 1992] axioms.
% English  : 

% Refs     : Benanav D. (1992), Recognising Unnecessary Clauses 
%            in Resolution Based Systems, In Journal of Automated 
%            Reasoning 9(1), 43-76.
% Source   : [Benanav, 1992]
% Names    : G16 [Benanav, 1992]

% Status   : 
% Syntax   : Number of clauses           :   60 (  19 non-Horn)(   3 unit)
%            Number of literals          :  247 (  92 equality)
%            Number of predicate symbols :    6 (   0 propositional)
%            Number of function symbols  :   11 (   2 constant)
%            Number of variables         :  155 (   0 singleton)
%            Maximal clause size         :   16
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Hilbert geometry 
include('Axioms/GEO003-0.ax').
include('Axioms/GEO003-0.eq').
%--------------------------------------------------------------------------
input_clause(there_is_a_plane,hypothesis,
    [++plane(a_plane)]).

input_clause(prove_every_plane_contains_3_noncollinear_points,theorem,
    [++collinear(X1,X2,X3),
     --point(X1),
     --point(X2),
     --point(X3),
     ++equal(X1,X2),
     ++equal(X1,X3),
     ++equal(X2,X3),
     --on(X1,a_plane),
     --on(X2,a_plane),
     --on(X3,a_plane)]).
%--------------------------------------------------------------------------
