%--------------------------------------------------------------------------
% File     : GEO077=3PtsNotColl-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry (Hilbert)
% Problem  : Three points not collinear if not on line
% Version  : [Benanav, 1992] axioms.
% English  : 

% Refs     : Benanav D. (1992), Recognising Unnecessary Clauses 
%            in Resolution Based Systems, In Journal of Automated 
%            Reasoning 9(1), 43-76.
% Source   : [Benanav, 1992]
% Names    : G11A [Benanav, 1992]

% Status   : 
% Syntax   : Number of clauses           :   69 (  18 non-Horn)(  13 unit)
%            Number of literals          :  247 (  92 equality)
%            Number of predicate symbols :    6 (   0 propositional)
%            Number of function symbols  :   14 (   5 constant)
%            Number of variables         :  152 (   0 singleton)
%            Maximal clause size         :   16
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Hilbert geometry 
include('Axioms/GEO003-0.ax').
include('Axioms/GEO003-0.eq').
%--------------------------------------------------------------------------
input_clause(point1,hypothesis,
    [++point(point1)]).

input_clause(point2,hypothesis,
    [++point(point2)]).

input_clause(point3,hypothesis,
    [++point(point3)]).

input_clause(line,hypothesis,
    [++line(a_line)]).

input_clause(point1_on_line,hypothesis,
    [++on(point1,a_line)]).

input_clause(point2_on_line,hypothesis,
    [++on(point2,a_line)]).

input_clause(point3_not_on_line,hypothesis,
    [--on(point3,a_line)]).

input_clause(point1_not_point2,hypothesis,
    [--equal(point1,point2)]).

input_clause(point1_not_point3,hypothesis,
    [--equal(point1,point3)]).

input_clause(point2_not_point3,hypothesis,
    [--equal(point2,point3)]).

input_clause(prove_points_noncollinear,theorem,
    [++collinear(point1,point2,point3)]).
%--------------------------------------------------------------------------
