%--------------------------------------------------------------------------
% File     : GEO076=PtNotOnLines-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry (Hilbert)
% Problem  : There is no point on every line
% Version  : [Benanav, 1992] axioms.
% English  : 

% Refs     : Benanav D. (1992), Recognising Unnecessary Clauses 
%            in Resolution Based Systems, In Journal of Automated 
%            Reasoning 9(1), 43-76.
% Source   : [Benanav, 1992]
% Names    : G15 [Benanav, 1992]

% Status   : 
% Syntax   : Number of clauses           :   60 (  18 non-Horn)(   3 unit)
%            Number of literals          :  239 (  89 equality)
%            Number of predicate symbols :    6 (   0 propositional)
%            Number of function symbols  :   11 (   2 constant)
%            Number of variables         :  153 (   0 singleton)
%            Maximal clause size         :   16
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Hilbert geometry 
include('Axioms/GEO003-0.ax').
include('Axioms/GEO003-0.eq').
%--------------------------------------------------------------------------
input_clause(there_is_a_point,hypothesis,
    [++point(a_point)]).

input_clause(prove_point_is_not_on_every_line,theorem,
    [--line(Line),
     ++on(a_point,Line)]).
%--------------------------------------------------------------------------
