%--------------------------------------------------------------------------
% File     : GEO075=EqidRefl-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Show reflexivity for equidistance is dependent
% Version  : [Quaife, 1989] axioms.
% English  : All of the axioms in GEO003.ax are known to be independent 
%            except A1 and A7. Tarski and his students have been unable 
%            to establish their status.

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : Q3.1 [Quaife, 1989]

% Status   : open
% Syntax   : Number of clauses           :   53 (   5 non-Horn)(   7 unit)
%            Number of literals          :  133 (  70 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   10 (   5 constant)
%            Number of variables         :  259 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Don't Include Tarski geometry axioms - proving one is dependent 
% include('axioms/GEO002-0.ax').
% include('axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
%----A1 - Reflexivity axiom for equidistance.
%----This is the one being proved 
%input_clause(reflexivity_for_equidistance,axiom,
%    [++equidistant(X,Y,Y,X)]).

%----A2 - Transitivity axiom for equidistance 
input_clause(transitivity_for_equidistance,axiom,
    [--equidistant(X,Y,Z,V),
     --equidistant(X,Y,V2,W),
     ++equidistant(Z,V,V2,W)]).

%----A3 Indentity axiom for equidistance 
input_clause(identity_for_equidistance,axiom,
    [--equidistant(X,Y,Z,Z),
     ++equal(X,Y)]).

%----A4 - Segment construction axiom, two clauses.
%----A4.1 
input_clause(segment_construction1,axiom,
    [++between(X,Y,extension(X,Y,W,V))]).

%----A4.2 
input_clause(segment_construction2,axiom,
    [++equidistant(Y,extension(X,Y,W,V),W,V)]).

%----A5 - Outer five-segment axiom 
input_clause(outer_five_segment,axiom,
    [--equidistant(X,Y,X1,Y1),
     --equidistant(Y,Z,Y1,Z1),
     --equidistant(X,V,X1,V1),
     --equidistant(Y,V,Y1,V1),
     --between(X,Y,Z),
     --between(X1,Y1,Z1),
     ++equal(X,Y),
     ++equidistant(Z,V,Z1,V1)]).

%----A6 - Identity axiom for betweenness 
input_clause(identity_for_betweeness,axiom,
    [--between(X,Y,X),
     ++equal(X,Y)]).

%----A7 - Inner Pasch axiom, two clauses.
%----A7.1 
input_clause(inner_pasch1,axiom,
    [--between(U,V,W),
     --between(Y,X,W),
     ++between(V,inner_pasch(U,V,W,X,Y),Y)]).

%----A7.2 
input_clause(inner_pasch2,axiom,
    [--between(U,V,W),
     --between(Y,X,W),
     ++between(X,inner_pasch(U,V,W,X,Y),U)]).

%----A8 - Lower dimension axiom, three clauses.
%----A8.1 
input_clause(lower_dimension1,axiom,
    [--between(lower_dimension_point_1,lower_dimension_point_2,
lower_dimension_point_3)]).

%----A8.2 
input_clause(lower_dimension2,axiom,
    [--between(lower_dimension_point_2,lower_dimension_point_3,
lower_dimension_point_1)]).

%----A8.3 
input_clause(lower_dimension3,axiom,
    [--between(lower_dimension_point_3,lower_dimension_point_1,
lower_dimension_point_2)]).

%----A9 - Upper dimension axiom 
input_clause(upper_dimension,axiom,
    [--equidistant(X,W,X,V),
     --equidistant(Y,W,Y,V),
     --equidistant(Z,W,Z,V),
     ++between(X,Y,Z),
     ++between(Y,Z,X),
     ++between(Z,X,Y),
     ++equal(W,V)]).

%----A10 - Euclid's axiom, three clauses.
%----A10.1 
input_clause(euclid1,axiom,
    [--between(U,W,Y),
     --between(V,W,X),
     ++equal(U,W),
     ++between(U,V,euclid1(U,V,W,X,Y))]).

%----A10.2 
input_clause(euclid2,axiom,
    [--between(U,W,Y),
     --between(V,W,X),
     ++equal(U,W),
     ++between(U,X,euclid2(U,V,W,X,Y))]).

%----A10.3 
input_clause(euclid3,axiom,
    [--between(U,W,Y),
     --between(V,W,X),
     ++equal(U,W),
     ++between(euclid1(U,V,W,X,Y),Y,euclid2(U,V,W,X,Y))]).

%----A11 - Weakened continuity axiom, two clauses.
%----A11.1 
input_clause(continuity1,axiom,
    [--equidistant(U,V,U,V1),
     --equidistant(U,X,U,X1),
     --between(U,V,X),
     --between(V,W,X),
     ++between(V1,continuous(U,V,V1,W,X,X1),X1)]).

%----A11.2 
input_clause(continuity2,axiom,
    [--equidistant(U,V,U,V1),
     --equidistant(U,X,U,X1),
     --between(U,V,X),
     --between(V,W,X),
     ++equidistant(U,W,U,continuous(U,V,V1,W,X,X1))]).

%----Equality substitution axioms 
input_clause(between_substitution1,axiom,
    [--equal(X,Y),
     --between(X,W,Z),
     ++between(Y,W,Z)]).

input_clause(between_substitution2,axiom,
    [--equal(X,Y),
     --between(W,X,Z),
     ++between(W,Y,Z)]).

input_clause(between_substitution3,axiom,
    [--equal(X,Y),
     --between(W,Z,X),
     ++between(W,Z,Y)]).

input_clause(equidistant_substitution1,axiom,
    [--equal(X,Y),
     --equidistant(X,V,W,Z),
     ++equidistant(Y,V,W,Z)]).

input_clause(equidistant_substitution2,axiom,
    [--equal(X,Y),
     --equidistant(V,X,W,Z),
     ++equidistant(V,Y,W,Z)]).

input_clause(equidistant_substitution3,axiom,
    [--equal(X,Y),
     --equidistant(V,W,X,Z),
     ++equidistant(V,W,Y,Z)]).

input_clause(equidistant_substitution4,axiom,
    [--equal(X,Y),
     --equidistant(V,W,Z,X),
     ++equidistant(V,W,Z,Y)]).

input_clause(inner_pasch_substitution1,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(X,V1,V2,V3,V4),inner_pasch(Y,V1,V2,V3,V4))]).

input_clause(inner_pasch_substitution2,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,X,V2,V3,V4),inner_pasch(V1,Y,V2,V3,V4))]).

input_clause(inner_pasch_substitution3,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,V2,X,V3,V4),inner_pasch(V1,V2,Y,V3,V4))]).

input_clause(inner_pasch_substitution4,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,V2,V3,X,V4),inner_pasch(V1,V2,V3,Y,V4))]).

input_clause(inner_pasch_substitution5,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,V2,V3,V4,X),inner_pasch(V1,V2,V3,V4,Y))]).

input_clause(euclid1_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(euclid1(A,C,D,E,F),euclid1(B,C,D,E,F))]).

input_clause(euclid1_substitutivity2,axiom,
    [--equal(G,H),
     ++equal(euclid1(I,G,J,K,L),euclid1(I,H,J,K,L))]).

input_clause(euclid1_substitutivity3,axiom,
    [--equal(M,N),
     ++equal(euclid1(O,P,M,Q,R),euclid1(O,P,N,Q,R))]).

input_clause(euclid1_substitutivity4,axiom,
    [--equal(S,T),
     ++equal(euclid1(U,V,W,S,X),euclid1(U,V,W,T,X))]).

input_clause(euclid1_substitutivity5,axiom,
    [--equal(Y,Z),
     ++equal(euclid1(A1,B1,C1,D1,Y),euclid1(A1,B1,C1,D1,Z))]).

input_clause(euclid2_substitutivity1,axiom,
    [--equal(E1,F1),
     ++equal(euclid2(E1,G1,H1,I1,J1),euclid2(F1,G1,H1,I1,J1))]).

input_clause(euclid2_substitutivity2,axiom,
    [--equal(K1,L1),
     ++equal(euclid2(M1,K1,N1,O1,P1),euclid2(M1,L1,N1,O1,P1))]).

input_clause(euclid2_substitutivity3,axiom,
    [--equal(Q1,R1),
     ++equal(euclid2(S1,T1,Q1,U1,V1),euclid2(S1,T1,R1,U1,V1))]).

input_clause(euclid2_substitutivity4,axiom,
    [--equal(W1,X1),
     ++equal(euclid2(Y1,Z1,A2,W1,B2),euclid2(Y1,Z1,A2,X1,B2))]).

input_clause(euclid2_substitutivity5,axiom,
    [--equal(C2,D2),
     ++equal(euclid2(E2,F2,G2,H2,C2),euclid2(E2,F2,G2,H2,D2))]).

input_clause(extend_substitution1,axiom,
    [--equal(X,Y),
     ++equal(extension(X,V1,V2,V3),extension(Y,V1,V2,V3))]).

input_clause(extend_substitution2,axiom,
    [--equal(X,Y),
     ++equal(extension(V1,X,V2,V3),extension(V1,Y,V2,V3))]).

input_clause(extend_substitution3,axiom,
    [--equal(X,Y),
     ++equal(extension(V1,V2,X,V3),extension(V1,V2,Y,V3))]).

input_clause(extend_substitution4,axiom,
    [--equal(X,Y),
     ++equal(extension(V1,V2,V3,X),extension(V1,V2,V3,Y))]).

input_clause(continuity_substitution1,axiom,
    [--equal(X,Y),
     ++equal(continuous(X,V1,V2,V3,V4,V5),
continuous(Y,V1,V2,V3,V4,V5))]).

input_clause(continuity_substitution2,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,X,V2,V3,V4,V5),
continuous(V1,Y,V2,V3,V4,V5))]).

input_clause(continuity_substitution3,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,V2,X,V3,V4,V5),
continuous(V1,V2,Y,V3,V4,V5))]).

input_clause(continuity_substitution4,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,V2,V3,X,V4,V5),
continuous(V1,V2,V3,Y,V4,V5))]).

input_clause(continuity_substitution5,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,V2,V3,V4,X,V5),
continuous(V1,V2,V3,V4,Y,V5))]).

input_clause(continuity_substitution6,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,V2,V3,V4,V5,X),
continuous(V1,V2,V3,V4,V5,Y))]).

input_clause(prove_reflexivity,theorem,
    [--equidistant(u,v,v,u)]).
%--------------------------------------------------------------------------
