%--------------------------------------------------------------------------
% File     : GEO074=OutPasch-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Prove the Outer Pasch Axiom
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : Q2 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   61 (   5 non-Horn)(   9 unit)
%            Number of literals          :  147 (  80 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   14 (   8 constant)
%            Number of variables         :  291 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : This presentation may have alternatives/be incorrect.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(outer_pasch_substitution1,axiom,
    [--equal(A,B),
     ++equal(outer_pasch(A,C,D,E,F),outer_pasch(B,C,D,E,F))]).

input_clause(outer_pasch_substitution2,axiom,
    [--equal(G,H),
     ++equal(outer_pasch(I,G,J,K,L),outer_pasch(I,H,J,K,L))]).

input_clause(outer_pasch_substitution3,axiom,
    [--equal(M,N),
     ++equal(outer_pasch(O,P,M,Q,R),outer_pasch(O,P,N,Q,R))]).

input_clause(outer_pasch_substitution4,axiom,
    [--equal(S,T),
     ++equal(outer_pasch(U,V,W,S,X),outer_pasch(U,V,W,T,X))]).

input_clause(outer_pasch_substitution5,axiom,
    [--equal(Y,Z),
     ++equal(outer_pasch(A1,B1,C1,D1,Y),outer_pasch(A1,B1,C1,D1,Z))]).

input_clause(w_between_u_and_x,hypothesis,
    [++between(u,w,x)]).

input_clause(x_between_v_and_y,hypothesis,
    [++between(v,x,y)]).

input_clause(prove_outer_pasch,theorem,
    [--between(u,outer_pasch(u,v,x,y,w),v),
     --between(y,w,outer_pasch(u,v,x,y,w))]).
%--------------------------------------------------------------------------
