%--------------------------------------------------------------------------
% File     : GEO073=DiagBsct-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : The diagonals of a non-degenerate rectancle bisect
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
% Source   : [Wos, 1988]
% Names    : Test Problem 11 [Wos, 1988]
%          : The Bisecting Diagonal Theorem [Wos, 1988]

% Status   : 
% Syntax   : Number of clauses           :   63 (   6 non-Horn)(  14 unit)
%            Number of literals          :  150 (  73 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   13 (   8 constant)
%            Number of variables         :  269 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : In [Wos, 1988] only one half of the symmetry is proved. Here 
%            both are proved, thus makiung this slightly stronger than the 
%            [Wos, 988] version.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO001-0.ax').
include('Axioms/GEO001-0.eq').
%--------------------------------------------------------------------------
input_clause(u_to_v_equals_w_to_x,hypothesis,
    [++equidistant(u,v,w,x)]).

input_clause(v_to_w_equals_x_to_u,hypothesis,
    [++equidistant(v,w,x,u)]).

input_clause(u_to_w_equals_v_to_x,hypothesis,
    [++equidistant(u,w,v,x)]).

input_clause(y_between_u_and_w,hypothesis,
    [++between(u,y,w)]).

input_clause(y_between_v_and_x,hypothesis,
    [++between(v,y,x)]).

input_clause(u_not_v,hypothesis,
    [--equal(u,v)]).

input_clause(x_not_u,hypothesis,
    [--equal(x,u)]).

%----This proves both ways 
input_clause(prove_bisection,theorem,
    [--equidistant(u,y,w,y),
     --equidistant(v,y,x,y)]).
%--------------------------------------------------------------------------
