%--------------------------------------------------------------------------
% File     : GEO071=PtsNotCollCor1-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Corollary 1 to non-collinear points theorem
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : W2.1 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   61 (   5 non-Horn)(  15 unit)
%            Number of literals          :  141 (  73 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   13 (   8 constant)
%            Number of variables         :  261 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : Proving corollaries from axioms is not usual.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(u_to_v_equals_w_to_x,hypothesis,
    [++equidistant(u,v,w,x)]).

input_clause(v_to_w_equals_x_to_u,hypothesis,
    [++equidistant(v,w,x,u)]).

input_clause(u_to_w_equals_v_to_x,hypothesis,
    [++equidistant(u,w,v,x)]).

input_clause(y_between_u_and_w,hypothesis,
    [++between(u,y,w)]).

input_clause(y_between_v_and_x,hypothesis,
    [++between(v,y,x)]).

input_clause(u_not_v,hypothesis,
    [--equal(u,v)]).

input_clause(x_not_u,hypothesis,
    [--equal(x,u)]).

input_clause(prove_u_equals_w,theorem,
    [--equal(u,w)]).
%--------------------------------------------------------------------------
