%--------------------------------------------------------------------------
% File     : GEO070=PtsNotColl-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Non-collinear points in the bisecting diagonal theorem
% Version  : [Quaife, 1989] axioms : Augmented.
% English  : Under the hypotheses of the bisecting diagonal theorem, the 
%            points u, v, w cannot be colinear.

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : W1 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :  158 (  26 non-Horn)(  38 unit)
%            Number of literals          :  397 ( 133 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   15 (   8 constant)
%            Number of variables         :  605 (  18 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%----Include definition of colinearity 
include('Axioms/GEO002-1.ax').
include('Axioms/GEO002-1.eq').
%----Include definition of reflection 
include('Axioms/GEO002-2.ax').
include('Axioms/GEO002-2.eq').
%----Include definition of insertion 
include('Axioms/GEO002-3.ax').
include('Axioms/GEO002-3.eq').
%--------------------------------------------------------------------------
input_clause(d1,axiom,
    [++equidistant(U,V,U,V)]).

input_clause(d2,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(W,X,U,V)]).

input_clause(d3,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(V,U,W,X)]).

input_clause(d4_1,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(U,V,X,W)]).

input_clause(d4_2,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(V,U,X,W)]).

input_clause(d4_3,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(W,X,V,U)]).

input_clause(d4_4,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(X,W,U,V)]).

input_clause(d4_5,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(X,W,V,U)]).

input_clause(d5,axiom,
    [--equidistant(U,V,W,X),
     --equidistant(W,X,Y,Z),
     ++equidistant(U,V,Y,Z)]).

input_clause(e1,axiom,
    [++equal(V,extension(U,V,W,W))]).

input_clause(b0,axiom,
    [--equal(Y,extension(U,V,W,X)),
     ++between(U,V,Y)]).

input_clause(r2_1,axiom,
    [++between(U,V,reflection(U,V))]).

input_clause(r2_2,axiom,
    [++equidistant(V,reflection(U,V),U,V)]).

input_clause(r3_1,axiom,
    [--equal(U,V),
     ++equal(V,reflection(U,V))]).

input_clause(r3_2,axiom,
    [++equal(U,reflection(U,U))]).

input_clause(r4,axiom,
    [--equal(V,reflection(U,V)),
     ++equal(U,V)]).

input_clause(d7,axiom,
    [++equidistant(U,U,V,V)]).

input_clause(d8,axiom,
    [--equidistant(U,V,U1,V1),
     --equidistant(V,W,V1,W1),
     --between(U,V,W),
     --between(U1,V1,W1),
     ++equidistant(U,W,U1,W1)]).

input_clause(d9,axiom,
    [--between(U,V,W),
     --between(U,V,X),
     --equidistant(V,W,V,X),
     ++equal(U,V),
     ++equal(W,X)]).

input_clause(d10_1,axiom,
    [--between(U,V,W),
     ++equal(U,V),
     ++equal(W,extension(U,V,V,W))]).

input_clause(d10_2,axiom,
    [--equidistant(W,X,Y,Z),
     ++equal(extension(U,V,W,X),extension(U,V,Y,Z)),
     ++equal(U,V)]).

input_clause(d10_3,axiom,
    [++equal(extension(U,V,U,V),extension(U,V,V,U)),
     ++equal(U,V)]).

input_clause(r5,axiom,
    [++equidistant(V,U,V,reflection(reflection(U,V),V))]).

input_clause(r6,axiom,
    [++equal(U,reflection(reflection(U,V),V))]).

input_clause(t3,axiom,
    [++between(U,V,V)]).

input_clause(b1,axiom,
    [--between(U,W,X),
     --equal(U,X),
     ++between(V,W,X)]).

input_clause(t1,axiom,
    [--between(U,V,W),
     ++between(W,V,U)]).

input_clause(t2,axiom,
    [++between(U,U,V)]).

input_clause(b2,axiom,
    [--between(U,V,W),
     --between(V,U,W),
     ++equal(U,V)]).

input_clause(b3,axiom,
    [--between(U,V,W),
     --between(U,W,V),
     ++equal(V,W)]).

input_clause(t6_1,axiom,
    [--between(U,V,W),
     --between(V,U,W),
     ++equal(U,V),
     ++equal(V,W)]).

input_clause(t6_2,axiom,
    [--between(U,V,W),
     --between(U,W,V),
     ++equal(U,V),
     ++equal(V,W)]).

input_clause(b4,axiom,
    [--between(U,V,W),
     --between(V,W,X),
     ++between(U,V,W)]).

input_clause(b5,axiom,
    [--between(U,V,W),
     --between(U,W,X),
     ++between(V,W,X)]).

input_clause(b6,axiom,
    [--between(U,V,W),
     --between(V,W,X),
     ++between(U,W,X),
     ++equal(V,W)]).

input_clause(b7,axiom,
    [--between(U,V,W),
     --between(V,W,X),
     ++between(U,V,X),
     ++equal(V,W)]).

input_clause(b8,axiom,
    [--between(U,V,X),
     --between(V,W,X),
     ++between(U,W,X)]).

input_clause(b9,axiom,
    [--between(U,V,W),
     --between(U,W,X),
     ++between(U,V,X)]).

input_clause(e2_1,axiom,
    [--equal(lower_dimension_point_1,lower_dimension_point_2)]).

input_clause(e2_2,axiom,
    [--equal(lower_dimension_point_2,lower_dimension_point_3)]).

input_clause(e2_3,axiom,
    [--equal(lower_dimension_point_1,lower_dimension_point_3)]).

input_clause(e3_1,axiom,
    [--equal(V,extension(U,V,lower_dimension_point_1,
lower_dimension_point_2))]).

input_clause(e3_2,axiom,
    [++equidistant(V,extension(U,V,lower_dimension_point_1,
lower_dimension_point_2),X,extension(W,X,lower_dimension_point_1,
lower_dimension_point_2))]).

input_clause(e3_3,axiom,
    [++between(U,V,extension(U,V,lower_dimension_point_1,
lower_dimension_point_2))]).

input_clause(b10,axiom,
    [--between(U,V,W),
     --between(U1,V1,W),
     --between(U,X,U1),
     ++between(X,inner_pasch(V1,inner_pasch(U,X,U1,V1,W),U,V,W),W),
     ++between(V,inner_pasch(V1,inner_pasch(U,X,U1,V1,W),U,V,W),V1)]).

input_clause(d11,axiom,
    [--between(U,V,W),
     --equidistant(U,W,U,W1),
     --equidistant(V,W,V,W1),
     ++equal(U,V),
     ++equal(W,W1)]).

input_clause(d12,axiom,
    [--equidistant(U,V,U1,V1),
     --equidistant(U,W,U1,W1),
     --equidistant(U,X,U1,X1),
     --equidistant(W,X,W1,X1),
     --between(U,V,W),
     --between(U,V1,W1),
     ++equidistant(V,X,V1,X1)]).

input_clause(d13,axiom,
    [--between(U,V,W),
     --between(U1,V1,W1),
     --equidistant(U,V,U1,V1),
     --equidistant(U,W,U1,W1),
     ++equidistant(V,W,V1,W1)]).

input_clause(d14,axiom,
    [--equidistant(U,V,U1,V1),
     --equidistant(V,W,V1,W1),
     --equidistant(U,X,U1,X1),
     --equidistant(W,X,W1,X1),
     --between(U,V,W),
     --between(U1,V1,W1),
     ++equidistant(V,X,V1,X1)]).

input_clause(d15,axiom,
    [--between(U,V,W),
     --equidistant(U,V,U,X),
     --equidistant(W,V,W,X),
     ++equal(V,X)]).

input_clause(i2_1,axiom,
    [++equidistant(U,V,U1,insertion(U1,W1,U,V))]).

input_clause(i2_2,axiom,
    [--between(U,V,W),
     --equidistant(U,W,U1,W1),
     ++between(U1,insertion(U1,W1,U,V),W1)]).

input_clause(i2_3,axiom,
    [--between(U,V,W),
     --equidistant(U,W,U1,W1),
     ++equidistant(V,W,insertion(U1,W1,U,V),W1)]).

input_clause(i3,axiom,
    [--between(U,V,W),
     ++equal(V,insertion(U,W,U,V))]).

input_clause(i4,axiom,
    [--equidistant(W,X,Y,Z),
     ++equal(insertion(U,V,W,X),insertion(U,V,Y,Z))]).

input_clause(b11,axiom,
    [--equidistant(U,V,U1,V1),
     --equidistant(V,W,V1,W1),
     --equidistant(U,W,U1,W1),
     --between(U,V,W),
     ++between(U1,V1,W1)]).

input_clause(b12,axiom,
    [--between(U,V,W),
     --between(U,V,X),
     ++equal(U,V),
     ++between(U,W,X),
     ++between(U,X,W)]).

input_clause(b13,axiom,
    [--between(U,V,W),
     --between(U,V,X),
     ++equal(U,V),
     ++between(V,W,X),
     ++between(V,X,W)]).

input_clause(t7,axiom,
    [--between(U,W,X),
     --between(V,W,X),
     ++equal(W,X),
     ++between(U,V,W),
     ++between(V,U,W)]).

input_clause(t9,axiom,
    [--between(U,V,X),
     --between(U,W,X),
     ++between(U,V,W),
     ++between(U,W,V)]).

input_clause(b14,axiom,
    [--between(U,V,X),
     --between(U,W,X),
     ++between(V,W,X),
     ++between(W,V,X)]).

input_clause(t8,axiom,
    [--between(U,V,Y),
     --between(V,W,X),
     --between(U,X,Y),
     ++between(U,W,Y)]).

input_clause(b15,axiom,
    [--between(U,V,W),
     --equidistant(U,V,U,W),
     ++equal(V,W)]).

input_clause(c2_1,axiom,
    [--between(W,V,U),
     ++colinear(U,V,W)]).

input_clause(c2_2,axiom,
    [--between(U,W,V),
     ++colinear(U,V,W)]).

input_clause(c2_3,axiom,
    [--between(V,U,W),
     ++colinear(U,V,W)]).

input_clause(t10_1,axiom,
    [--colinear(U,V,W),
     ++colinear(W,V,U)]).

input_clause(t10_2,axiom,
    [--colinear(U,V,W),
     ++colinear(V,W,U)]).

input_clause(t10_3,axiom,
    [--colinear(U,V,W),
     ++colinear(U,W,V)]).

input_clause(t10_4,axiom,
    [--colinear(U,V,W),
     ++colinear(W,U,V)]).

input_clause(t10_5,axiom,
    [--colinear(U,V,W),
     ++colinear(V,U,W)]).

input_clause(t11,axiom,
    [--colinear(lower_dimension_point_1,lower_dimension_point_2,
lower_dimension_point_3)]).

input_clause(c3_1,axiom,
    [++colinear(X,X,Y)]).

input_clause(c3_2,axiom,
    [++colinear(X,Y,X)]).

input_clause(c3_3,axiom,
    [++colinear(Y,X,X)]).

input_clause(c3_4,axiom,
    [--equal(X,Y),
     ++colinear(X,Z,Y)]).

input_clause(c4,axiom,
    [--equidistant(U,V,U1,V1),
     --equidistant(V,W,V1,W1),
     --equidistant(U,W,U1,W1),
     --colinear(U,V,W),
     ++colinear(U1,V1,W1)]).

input_clause(t12_1,axiom,
    [--colinear(U,V,W),
     --colinear(U,V,X),
     ++colinear(U,W,X),
     ++equal(U,V)]).

input_clause(t12_2,axiom,
    [--colinear(U,V,W),
     --colinear(U,V,X),
     ++colinear(V,W,X),
     ++equal(U,V)]).

input_clause(c5_1,axiom,
    [--colinear(W,V,U),
     --colinear(X,V,U),
     ++colinear(X,W,U),
     ++equal(U,V)]).

input_clause(c5_2,axiom,
    [--colinear(W,V,U),
     --colinear(X,V,U),
     ++colinear(X,W,V),
     ++equal(U,V)]).

input_clause(t13,axiom,
    [--colinear(U,V,W),
     --colinear(U,V,W1),
     --colinear(U,V,W2),
     ++colinear(W,W1,W2),
     ++equal(U,V)]).

input_clause(u_to_v_equals_w_to_x,hypothesis,
    [++equidistant(u,v,w,x)]).

input_clause(v_to_w_equals_x_to_u,hypothesis,
    [++equidistant(v,w,x,u)]).

input_clause(u_to_w_equals_v_to_x,hypothesis,
    [++equidistant(u,w,v,x)]).

input_clause(y_between_u_and_w,hypothesis,
    [++between(u,y,w)]).

input_clause(y_between_v_and_x,hypothesis,
    [++between(v,y,x)]).

input_clause(u_not_v,hypothesis,
    [--equal(u,v)]).

input_clause(x_not_u,hypothesis,
    [--equal(x,u)]).

input_clause(prove_uvw_not_colinear,theorem,
    [++colinear(u,v,w)]).
%--------------------------------------------------------------------------
