%--------------------------------------------------------------------------
% File     : GEO070=PtsNotColl-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Non-collinear points in the bisecting diagonal theorem
% Version  : [Quaife, 1989] axioms.
% English  : Under the hypotheses of the bisecting diagonal theorem, the 
%            points u, v, w cannot be colinear.

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : W1 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   68 (   6 non-Horn)(  15 unit)
%            Number of literals          :  160 (  75 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   13 (   8 constant)
%            Number of variables         :  285 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%----Include definition of colinearity 
include('Axioms/GEO002-1.ax').
include('Axioms/GEO002-1.eq').
%--------------------------------------------------------------------------
input_clause(u_to_v_equals_w_to_x,hypothesis,
    [++equidistant(u,v,w,x)]).

input_clause(v_to_w_equals_x_to_u,hypothesis,
    [++equidistant(v,w,x,u)]).

input_clause(u_to_w_equals_v_to_x,hypothesis,
    [++equidistant(u,w,v,x)]).

input_clause(y_between_u_and_w,hypothesis,
    [++between(u,y,w)]).

input_clause(y_between_v_and_x,hypothesis,
    [++between(v,y,x)]).

input_clause(u_not_v,hypothesis,
    [--equal(u,v)]).

input_clause(x_not_u,hypothesis,
    [--equal(x,u)]).

input_clause(prove_uvw_not_colinear,theorem,
    [++colinear(u,v,w)]).
%--------------------------------------------------------------------------
