%--------------------------------------------------------------------------
% File     : GEO069=CollEqn3-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : A property of collinearity
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : C5 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   64 (   6 non-Horn)(  10 unit)
%            Number of literals          :  157 (  74 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   12 (   7 constant)
%            Number of variables         :  285 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : This presentation may have alternatives/be incorrect.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%----Include definition of colinearity 
include('Axioms/GEO002-1.ax').
include('Axioms/GEO002-1.eq').
%--------------------------------------------------------------------------
input_clause(u_not_v,hypothesis,
    [--equal(u,v)]).

input_clause(wvu_colinear,hypothesis,
    [++colinear(w,v,u)]).

input_clause(xvu_colinear,hypothesis,
    [++colinear(x,v,u)]).

input_clause(prove_xwu_and_xwv_colinear,theorem,
    [--colinear(x,w,u),
     --colinear(x,w,v)]).
%--------------------------------------------------------------------------
