%--------------------------------------------------------------------------
% File     : GEO068=CollSimSits-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Theorem of similar situations for collinear U, V, W
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : C4 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   65 (   6 non-Horn)(  12 unit)
%            Number of literals          :  157 (  73 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   14 (   9 constant)
%            Number of variables         :  285 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%----Include definition of colinearity 
include('Axioms/GEO002-1.ax').
include('Axioms/GEO002-1.eq').
%--------------------------------------------------------------------------
input_clause(u_to_v_equals_u1_to_v1,hypothesis,
    [++equidistant(u,v,u1,v1)]).

input_clause(v_to_w_equals_v1_to_w1,hypothesis,
    [++equidistant(v,w,v1,w1)]).

input_clause(u_to_w_equals_u1_to_w1,hypothesis,
    [++equidistant(u,w,u1,w1)]).

input_clause(uvw_colinear,hypothesis,
    [++colinear(u,v,w)]).

input_clause(prove_u1v1w1_colinear,theorem,
    [--colinear(u1,v1,w1)]).
%--------------------------------------------------------------------------
