%--------------------------------------------------------------------------
% File     : GEO067=2PtsColl-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Any two points are collinear
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : C3 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   62 (   6 non-Horn)(   7 unit)
%            Number of literals          :  160 (  74 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   11 (   6 constant)
%            Number of variables         :  285 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : This presentation may have alternatives/be incorrect.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%----Include definition of colinearity 
include('Axioms/GEO002-1.ax').
include('Axioms/GEO002-1.eq').
%--------------------------------------------------------------------------
input_clause(part_1,theorem,
    [--colinear(x,x,y),
     --colinear(x,y,x),
     --colinear(y,x,x),
     ++equal(x,y)]).

input_clause(part_2,theorem,
    [--colinear(x,x,y),
     --colinear(x,y,x),
     --colinear(y,x,x),
     --colinear(x,z,y)]).
%--------------------------------------------------------------------------
