%--------------------------------------------------------------------------
% File     : GEO066=CollCor3-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Corollary 3 to collinearity
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : C2.3 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   62 (   6 non-Horn)(   9 unit)
%            Number of literals          :  154 (  73 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   11 (   6 constant)
%            Number of variables         :  285 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : Proving corollaries from axioms is not usual.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%----Include definition of colinearity 
include('Axioms/GEO002-1.ax').
include('Axioms/GEO002-1.eq').
%--------------------------------------------------------------------------
input_clause(u_between_v_and_w,hypothesis,
    [++between(v,u,w)]).

input_clause(prove_uvw_colinear,theorem,
    [--colinear(u,v,w)]).
%--------------------------------------------------------------------------
