%--------------------------------------------------------------------------
% File     : GEO061=PtIntsc-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Theorem of point insertion
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : I2 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   61 (   5 non-Horn)(   8 unit)
%            Number of literals          :  149 (  79 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   14 (   8 constant)
%            Number of variables         :  285 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : This presentation may have alternatives/be incorrect.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%----Include definition of insertion 
include('Axioms/GEO002-3.ax').
include('Axioms/GEO002-3.eq').
%--------------------------------------------------------------------------
input_clause(part_1,theorem,
    [--equidistant(u,v,u1,insertion(u1,w1,u,v)),
     ++between(u,v,w)]).

input_clause(part_2,theorem,
    [--equidistant(u,v,u1,insertion(u1,w1,u,v)),
     ++equidistant(u,w,u1,w1)]).

input_clause(part_3,theorem,
    [--equidistant(u,v,u1,insertion(u1,w1,u,v)),
     --between(u1,insertion(u1,w1,u,v),w1),
     --equidistant(v,w,insertion(u1,w1,u,v),w1)]).
%--------------------------------------------------------------------------
