%--------------------------------------------------------------------------
% File     : GEO058=ReflcFixPtUnq-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : U is the only fixed point of reflection(U,V)
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : R4 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   58 (   5 non-Horn)(  10 unit)
%            Number of literals          :  140 (  77 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (   5 constant)
%            Number of variables         :  269 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%----Include definition of reflection 
include('Axioms/GEO002-2.ax').
include('Axioms/GEO002-2.eq').
%--------------------------------------------------------------------------
input_clause(v_equals_reflection,hypothesis,
    [++equal(v,reflection(u,v))]).

input_clause(prove_u_equals_v,theorem,
    [--equal(u,v)]).
%--------------------------------------------------------------------------
