%--------------------------------------------------------------------------
% File     : GEO055=SegConsCor3-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Corollary 3 to the segment construction axiom
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : R2.2 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   57 (   5 non-Horn)(   9 unit)
%            Number of literals          :  139 (  75 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (   5 constant)
%            Number of variables         :  269 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : Proving corollaries from axioms is not usual.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%----Include definition of reflection 
include('Axioms/GEO002-2.ax').
include('Axioms/GEO002-2.eq').
%--------------------------------------------------------------------------
input_clause(prove_equidistance,theorem,
    [--equidistant(v,reflection(u,v),u,v)]).
%--------------------------------------------------------------------------
