%--------------------------------------------------------------------------
% File     : GEO050=1stBtwnOutConn-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : First outer connectivity property of betweenness
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Tarski A. (1959), What is Elementary Geometry?, 
%            In Henkin L. (Ed), Proceedings of an International 
%            Symposium :
%            The axiomatic method with special reference to geometry and 
%            physics, (University of California, Berkeley, 1957), (Studies 
%            in logic and the foundations of mathematics, Volume ??), 
%            North-Holland, The Netherlands.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : B12 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   58 (   5 non-Horn)(  12 unit)
%            Number of literals          :  138 (  71 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   12 (   7 constant)
%            Number of variables         :  261 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : This is Axiom 3 in [Tarski, 1959]
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(v_between_u_and_w,hypothesis,
    [++between(u,v,w)]).

input_clause(v_between_u_and_x,hypothesis,
    [++between(u,v,x)]).

input_clause(u_not_v,hypothesis,
    [--equal(u,v)]).

input_clause(w_not_between_u_and_x,hypothesis,
    [--between(u,w,x)]).

input_clause(prove_x_between_u_and_w,theorem,
    [--between(u,x,w)]).
%--------------------------------------------------------------------------
