%--------------------------------------------------------------------------
% File     : GEO048=InrPtsTri-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Inner points of triangle
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : B10 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   58 (   5 non-Horn)(  12 unit)
%            Number of literals          :  138 (  70 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   14 (   9 constant)
%            Number of variables         :  261 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(v_between_u_and_w,hypothesis,
    [++between(u,v,w)]).

input_clause(v1_between_u1_and_w,hypothesis,
    [++between(u1,v1,w)]).

input_clause(x_between_u_and_u1,hypothesis,
    [++between(u,x,u1)]).

input_clause(prove_conclusion1,theorem,
    [--between(x,inner_pasch(v1,inner_pasch(u,x,u1,v1,w),u,v,w),w)]).

input_clause(prove_conclusion2,theorem,
    [--between(v,inner_pasch(v1,inner_pasch(u,x,u1,v1,w),u,v,w),v1)]).
%--------------------------------------------------------------------------
