%--------------------------------------------------------------------------
% File     : GEO041=BtwnASymCor-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Corollary to antisymmetry of betweenness in its first 2 arguments
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : B3 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   56 (   5 non-Horn)(  10 unit)
%            Number of literals          :  136 (  71 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (   6 constant)
%            Number of variables         :  261 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : Proving corollaries from axioms is not usual.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(v_between_u_and_w,hypothesis,
    [++between(u,v,w)]).

input_clause(w_between_u_and_v,hypothesis,
    [++between(u,w,v)]).

input_clause(prove_v_is_w,theorem,
    [--equal(v,w)]).
%--------------------------------------------------------------------------
