%--------------------------------------------------------------------------
% File     : GEO038=SegConsCor1-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Corollary 1 to the segment contruction axiom
% Version  : [Quaife, 1989] axioms : Augmented.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : B0 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   65 (   5 non-Horn)(  11 unit)
%            Number of literals          :  154 (  72 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   13 (   8 constant)
%            Number of variables         :  300 (   4 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(d1,axiom,
    [++equidistant(U,V,U,V)]).

input_clause(d2,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(W,X,U,V)]).

input_clause(d3,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(V,U,W,X)]).

input_clause(d4_1,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(U,V,X,W)]).

input_clause(d4_2,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(V,U,X,W)]).

input_clause(d4_3,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(W,X,V,U)]).

input_clause(d4_4,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(X,W,U,V)]).

input_clause(d4_5,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(X,W,V,U)]).

input_clause(d5,axiom,
    [--equidistant(U,V,W,X),
     --equidistant(W,X,Y,Z),
     ++equidistant(U,V,Y,Z)]).

input_clause(e1,axiom,
    [++equal(V,extension(U,V,W,W))]).

input_clause(y_is_extension,hypothesis,
    [++equal(y,extension(u,v,w,x))]).

input_clause(prove_corollary,theorem,
    [--between(u,v,y)]).
%--------------------------------------------------------------------------
