%--------------------------------------------------------------------------
% File     : GEO036=AxPtsEx-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : The 3 axiom set points are distinct
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : E2 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   54 (   6 non-Horn)(   7 unit)
%            Number of literals          :  136 (  73 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   3 constant)
%            Number of variables         :  261 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_axioms_points_are_distinct,theorem,
    [++equal(lower_dimension_point_1,lower_dimension_point_2),
     ++equal(lower_dimension_point_2,lower_dimension_point_3),
     ++equal(lower_dimension_point_1,lower_dimension_point_3)]).
%--------------------------------------------------------------------------
