%--------------------------------------------------------------------------
% File     : GEO035=NullExt-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : A null extension does not extend a line
% Version  : [Quaife, 1989] axioms : Augmented.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : E1 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   63 (   5 non-Horn)(   9 unit)
%            Number of literals          :  152 (  71 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (   6 constant)
%            Number of variables         :  297 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(d1,axiom,
    [++equidistant(U,V,U,V)]).

input_clause(d2,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(W,X,U,V)]).

input_clause(d3,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(V,U,W,X)]).

input_clause(d4_1,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(U,V,X,W)]).

input_clause(d4_2,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(V,U,X,W)]).

input_clause(d4_3,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(W,X,V,U)]).

input_clause(d4_4,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(X,W,U,V)]).

input_clause(d4_5,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(X,W,V,U)]).

input_clause(d5,axiom,
    [--equidistant(U,V,W,X),
     --equidistant(W,X,Y,Z),
     ++equidistant(U,V,Y,Z)]).

input_clause(prove_null_extension,theorem,
    [--equal(v,extension(u,v,w,w))]).
%--------------------------------------------------------------------------
