%--------------------------------------------------------------------------
% File     : GEO034=1stInr5SegCor-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Corollary to the first inner five-segment theorem
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : D15 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   57 (   5 non-Horn)(  11 unit)
%            Number of literals          :  137 (  71 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   12 (   7 constant)
%            Number of variables         :  261 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : Proving corollaries from axioms is not usual.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(v_between_u_and_w,hypothesis,
    [++between(u,v,w)]).

input_clause(u_to_v_equals_u_to_x,hypothesis,
    [++equidistant(u,v,u,x)]).

input_clause(w_to_v_equals_w_to_x,hypothesis,
    [++equidistant(w,v,w,x)]).

input_clause(prove_v_is_x,theorem,
    [--equal(v,x)]).
%--------------------------------------------------------------------------
