%--------------------------------------------------------------------------
% File     : GEO033=1stInr5Seg-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : First inner five-segment theorem
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : D14 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   60 (   5 non-Horn)(  14 unit)
%            Number of literals          :  140 (  70 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   16 (  11 constant)
%            Number of variables         :  261 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(u_to_v_equals_u1_to_v1,hypothesis,
    [++equidistant(u,v,u1,v1)]).

input_clause(v_to_w_equals_v1_to_w1,hypothesis,
    [++equidistant(v,w,v1,w1)]).

input_clause(u_to_x_equals_u1_to_x1,hypothesis,
    [++equidistant(u,x,u1,x1)]).

input_clause(w_to_x_equals_w1_to_x1,hypothesis,
    [++equidistant(w,x,w1,x1)]).

input_clause(v_between_u_and_w,hypothesis,
    [++between(u,v,w)]).

input_clause(v1_between_u1_and_w1,hypothesis,
    [++between(u1,v1,w1)]).

input_clause(prove_v_to_x_equals_v1_to_x1,theorem,
    [--equidistant(v,x,v1,x1)]).
%--------------------------------------------------------------------------
