%--------------------------------------------------------------------------
% File     : GEO028=ExtUnqCor2-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Corollary 2 to unique extension
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : D10.2 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   56 (   5 non-Horn)(  10 unit)
%            Number of literals          :  136 (  72 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   14 (   9 constant)
%            Number of variables         :  261 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(w_to_x_equals_y_to_z,hypothesis,
    [++equidistant(w,x,y,z)]).

input_clause(u_not_v,hypothesis,
    [--equal(u,v)]).

input_clause(prove_equal_extensions,theorem,
    [--equal(extension(u,v,w,x),extension(u,v,y,z))]).
%--------------------------------------------------------------------------
