%--------------------------------------------------------------------------
% File     : GEO025=SumEqSeg-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Addition of equal segments
% Version  : [Quaife, 1989] axioms : Augmented.
% English  : 

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : D8 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   78 (   5 non-Horn)(  19 unit)
%            Number of literals          :  172 (  82 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   15 (   9 constant)
%            Number of variables         :  324 (   6 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%----Include definition of reflection 
include('Axioms/GEO002-2.ax').
include('Axioms/GEO002-2.eq').
%--------------------------------------------------------------------------
input_clause(d1,axiom,
    [++equidistant(U,V,U,V)]).

input_clause(d2,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(W,X,U,V)]).

input_clause(d3,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(V,U,W,X)]).

input_clause(d4_1,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(U,V,X,W)]).

input_clause(d4_2,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(V,U,X,W)]).

input_clause(d4_3,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(W,X,V,U)]).

input_clause(d4_4,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(X,W,U,V)]).

input_clause(d4_5,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(X,W,V,U)]).

input_clause(d5,axiom,
    [--equidistant(U,V,W,X),
     --equidistant(W,X,Y,Z),
     ++equidistant(U,V,Y,Z)]).

input_clause(e1,axiom,
    [++equal(V,extension(U,V,W,W))]).

input_clause(b0,axiom,
    [--equal(Y,extension(U,V,W,X)),
     ++between(U,V,Y)]).

input_clause(r2_1,axiom,
    [++between(U,V,reflection(U,V))]).

input_clause(r2_2,axiom,
    [++equidistant(V,reflection(U,V),U,V)]).

input_clause(r3_1,axiom,
    [--equal(U,V),
     ++equal(V,reflection(U,V))]).

input_clause(r3_2,axiom,
    [++equal(U,reflection(U,U))]).

input_clause(r4,axiom,
    [--equal(V,reflection(U,V)),
     ++equal(U,V)]).

input_clause(d7,axiom,
    [++equidistant(U,U,V,V)]).

input_clause(u_to_v_equals_u1_to_v1,hypothesis,
    [++equidistant(u,v,u1,v1)]).

input_clause(v_to_w_equals_v1_to_w1,hypothesis,
    [++equidistant(v,w,v1,w1)]).

input_clause(v_between_u_and_w,hypothesis,
    [++between(u,v,w)]).

input_clause(v1_between_u1_and_w1,hypothesis,
    [++between(u1,v1,w1)]).

input_clause(prove_equal_sums,theorem,
    [--equidistant(u,w,u1,w1)]).
%--------------------------------------------------------------------------
