%--------------------------------------------------------------------------
% File     : GEO022=EqidTrans-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Ordinary transitivity of equidistance
% Version  : [Quaife, 1989] axioms.
% English  : This form of transitivity is different from that expressed 
%            in the axioms.

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : D5 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   56 (   5 non-Horn)(  10 unit)
%            Number of literals          :  136 (  70 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   14 (   9 constant)
%            Number of variables         :  261 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : In [Quiafe, 1989] the next problem (D6) is omitted.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(u_to_v_equals_w_to_x,hypothesis,
    [++equidistant(u,v,w,x)]).

input_clause(w_to_x_equals_y_to_z,hypothesis,
    [++equidistant(w,x,y,z)]).

input_clause(prove_transitivity,theorem,
    [--equidistant(u,v,y,z)]).
%--------------------------------------------------------------------------
