%--------------------------------------------------------------------------
% File     : GEO021=EqidSymmCor5-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Corollary 5 to symmetries of equidistance
% Version  : [Quaife, 1989] axioms.
% English  : Show that if the distance from A to B equals the distance 
%            from C to D, then the distance from D to C equals the 
%            distance from B to A.

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : D4.5 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   55 (   5 non-Horn)(   9 unit)
%            Number of literals          :  135 (  70 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   12 (   7 constant)
%            Number of variables         :  261 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : Proving corollaries from axioms is not usual.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(u_to_v_equals_w_to_x,hypothesis,
    [++equidistant(u,v,w,x)]).

input_clause(prove_symmetry,theorem,
    [--equidistant(x,w,v,u)]).
%--------------------------------------------------------------------------
