%--------------------------------------------------------------------------
% File     : GEO014=EqidRefl-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Ordinary reflexivity of equidistance
% Version  : [Quaife, 1989] axioms.
% English  : This shows that the distance from A to B is the same as the 
%            distance from A to B. This is different from the axiom which 
%            states that the distance from A to B is the same as the 
%            distance from B to A.

% Refs     : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : D1 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   54 (   5 non-Horn)(   8 unit)
%            Number of literals          :  134 (  70 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   10 (   5 constant)
%            Number of variables         :  261 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_reflexivity,theorem,
    [--equidistant(u,v,u,v)]).
%--------------------------------------------------------------------------
