%--------------------------------------------------------------------------
% File     : GEO013=Coll5Pts-1 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Geometry
% Problem  : Collinearity for 5 points
% Version  : [McCharen, et al., 1976] axioms.
% English  : If z1, z2, and z3 are each collinear with distinct points 
%            x and y, then z1, z2, and z3 are collinear.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
% Source   : [ANL]
% Names    : T13 [McCharen, et al., 1976]
%          : t13.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   67 (   7 non-Horn)(  12 unit)
%            Number of literals          :  165 (  75 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   13 (   8 constant)
%            Number of variables         :  293 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
% Bugfixes : v1.0.1 - Bug in GEO001-0.eq fixed.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO001-0.ax').
include('Axioms/GEO001-0.eq').
%----Include Tarski geometry axioms for colinearity 
include('Axioms/GEO001-1.ax').
include('Axioms/GEO001-1.eq').
%--------------------------------------------------------------------------
input_clause(a_not_b,hypothesis,
    [--equal(a,b)]).

input_clause(and1_colinear,hypothesis,
    [++colinear(a,b,d1)]).

input_clause(abd2_colinear,hypothesis,
    [++colinear(a,b,d2)]).

input_clause(abd3_colinear,hypothesis,
    [++colinear(a,b,d3)]).

input_clause(prove_d1d2d3_colinear,theorem,
    [--colinear(d1,d2,d3)]).
%--------------------------------------------------------------------------
