%--------------------------------------------------------------------------
% File     : GEO012=Coll4Pts-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Collinearity for 4 points
% Version  : [Quaife, 1989] axioms.
% English  : If any three distinct points x, y, and z are collinear and 
%            a fourth point w is collinear with x and y, then 
%            w is collinear with x and z and also with x and y.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : T12 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   64 (   6 non-Horn)(  10 unit)
%            Number of literals          :  157 (  74 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   12 (   7 constant)
%            Number of variables         :  285 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : This presentation may have alternatives/be incorrect.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%----Include Tarski geometry axioms for colinearity 
include('Axioms/GEO002-1.ax').
include('Axioms/GEO002-1.eq').
%--------------------------------------------------------------------------
input_clause(a_not_b,hypothesis,
    [--equal(a,b)]).

input_clause(abc_colinear,hypothesis,
    [++colinear(a,b,c)]).

input_clause(abd_colinear,hypothesis,
    [++colinear(a,b,d)]).

input_clause(prove_colinearity,theorem,
    [--colinear(a,c,d),
     --colinear(b,c,d)]).
%--------------------------------------------------------------------------
