%--------------------------------------------------------------------------
% File     : GEO012=Coll4Pts-1 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Geometry
% Problem  : Collinearity for 4 points
% Version  : [McCharen, et al., 1976] axioms.
% English  : If any three distinct points x, y, and z are collinear and 
%            a fourth point w is collinear with x and y, then 
%            w is collinear with x and z and also with x and y.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
% Source   : [ANL]
% Names    : T12 [McCharen, et al., 1976]
%          : t12.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   68 (   7 non-Horn)(  12 unit)
%            Number of literals          :  167 (  77 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   12 (   7 constant)
%            Number of variables         :  293 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
% Bugfixes : v1.0.1 - Bug in GEO001-0.eq fixed.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO001-0.ax').
include('Axioms/GEO001-0.eq').
%----Include Tarski geometry axioms for colinearity 
include('Axioms/GEO001-1.ax').
include('Axioms/GEO001-1.eq').
%--------------------------------------------------------------------------
input_clause(a_not_b,hypothesis,
    [--equal(a,b)]).

%---Quaife states that the next two hypotheses are unnecessary
input_clause(a_not_c,hypothesis,
    [--equal(a,c)]).

input_clause(b_not_c,hypothesis,
    [--equal(b,c)]).

input_clause(abc_colinear,hypothesis,
    [++colinear(a,b,c)]).

input_clause(abd_colinear,hypothesis,
    [++colinear(a,b,d)]).

input_clause(prove_colinearity,theorem,
    [--colinear(a,c,d),
     --colinear(b,c,d)]).
%--------------------------------------------------------------------------
