%--------------------------------------------------------------------------
% File     : GEO011=AxPtsNotColl-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : The axiom set points are not collinear
% Version  : [Quaife, 1989] axioms : Reduced & Augmented > Incomplete.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [ANL]
% Names    : T11 [Quaife, 1989]
%          : t11.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   39 (   2 non-Horn)(   8 unit)
%            Number of literals          :   90 (  39 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    6 (   3 constant)
%            Number of variables         :  143 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : Equidistant reformulated to same_distance
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms for colinearity 
include('Axioms/GEO002-1.ax').
include('Axioms/GEO002-1.eq').
%--------------------------------------------------------------------------
%----A1 - Reflexivity axiom for equidistance 
input_clause(reflexivity_for_equidistance,axiom,
    [++equal_distance(distance(X,Y),distance(Y,X))]).

%----A2 - Transitivity axiom for equidistance 
input_clause(transitivity_for_equidistance,axiom,
    [--equal_distance(distance(X,Y),distance(Z,V)),
     --equal_distance(distance(X,Y),distance(V2,W)),
     ++equal_distance(distance(Z,V),distance(V2,W))]).

%----A3 Indentity axiom for equidistance 
input_clause(identity_for_equidistance,axiom,
    [--equal_distance(distance(X,Y),distance(Z,Z)),
     ++equal(X,Y)]).

%----A4 - Segment construction axiom, two clauses.
%----A4.1 
input_clause(segment_construction1,axiom,
    [++between(X,Y,extension(X,Y,W,V))]).

%----A4.2 
input_clause(segment_construction2,axiom,
    [++equal_distance(distance(Y,extension(X,Y,W,V)),distance(W,V))]).

%----A5 - Outer five-segment axiom 
input_clause(outer_five_segment,axiom,
    [--equal_distance(distance(X,Y),distance(X1,Y1)),
     --equal_distance(distance(Y,Z),distance(Y1,Z1)),
     --equal_distance(distance(X,V),distance(X1,V1)),
     --equal_distance(distance(Y,V),distance(Y1,V1)),
     --between(X,Y,Z),
     --between(X1,Y1,Z1),
     ++equal(X,Y),
     ++equal_distance(distance(Z,V),distance(Z1,V1))]).

%----A6 - Identity axiom for betweenness 
input_clause(identity_for_betweeness,axiom,
    [--between(X,Y,X),
     ++equal(X,Y)]).

%----A7 - Inner Pasch axiom, two clauses.
%----A7.1 
input_clause(inner_pasch1,axiom,
    [--between(U,V,W),
     --between(Y,X,W),
     ++between(V,inner_pasch(U,V,W,X,Y),Y)]).

%----A7.2 
input_clause(inner_pasch2,axiom,
    [--between(U,V,W),
     --between(Y,X,W),
     ++between(X,inner_pasch(U,V,W,X,Y),U)]).

%----A8 - Lower dimension axiom, three clauses.
%----A8.1 
input_clause(lower_dimension1,axiom,
    [--between(lower_dimension_point_1,lower_dimension_point_2,
lower_dimension_point_3)]).

%----A8.2 
input_clause(lower_dimension2,axiom,
    [--between(lower_dimension_point_2,lower_dimension_point_3,
lower_dimension_point_1)]).

%----A8.3 
input_clause(lower_dimension3,axiom,
    [--between(lower_dimension_point_3,lower_dimension_point_1,
lower_dimension_point_2)]).

%----Equality substitution axioms 
input_clause(distance_substitution1,axiom,
    [--equal(A,B),
     ++equal(distance(A,C),distance(B,C))]).

input_clause(distance_substitution2,axiom,
    [--equal(D,E),
     ++equal(distance(F,D),distance(F,E))]).

input_clause(between_substitution1,axiom,
    [--equal(X,Y),
     --between(X,W,Z),
     ++between(Y,W,Z)]).

input_clause(between_substitution2,axiom,
    [--equal(X,Y),
     --between(W,X,Z),
     ++between(W,Y,Z)]).

input_clause(between_substitution3,axiom,
    [--equal(X,Y),
     --between(W,Z,X),
     ++between(W,Z,Y)]).

input_clause(equal_distance_substitution1,axiom,
    [--equal(X,Y),
     --equal_distance(X,Z),
     ++equal_distance(Y,Z)]).

input_clause(equal_distance_substitution2,axiom,
    [--equal(X,Y),
     --equal_distance(Z,X),
     ++equal_distance(Z,Y)]).

input_clause(inner_pasch_substitution1,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(X,V1,V2,V3,V4),inner_pasch(Y,V1,V2,V3,V4))]).

input_clause(inner_pasch_substitution2,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,X,V2,V3,V4),inner_pasch(V1,Y,V2,V3,V4))]).

input_clause(inner_pasch_substitution3,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,V2,X,V3,V4),inner_pasch(V1,V2,Y,V3,V4))]).

input_clause(inner_pasch_substitution4,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,V2,V3,X,V4),inner_pasch(V1,V2,V3,Y,V4))]).

input_clause(inner_pasch_substitution5,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,V2,V3,V4,X),inner_pasch(V1,V2,V3,V4,Y))]).

input_clause(extend_substitution1,axiom,
    [--equal(X,Y),
     ++equal(extension(X,V1,V2,V3),extension(Y,V1,V2,V3))]).

input_clause(extend_substitution2,axiom,
    [--equal(X,Y),
     ++equal(extension(V1,X,V2,V3),extension(V1,Y,V2,V3))]).

input_clause(extend_substitution3,axiom,
    [--equal(X,Y),
     ++equal(extension(V1,V2,X,V3),extension(V1,V2,Y,V3))]).

input_clause(extend_substitution4,axiom,
    [--equal(X,Y),
     ++equal(extension(V1,V2,V3,X),extension(V1,V2,V3,Y))]).

input_clause(prove_lower_dimension_points_not_colinear,theorem,
    [++colinear(lower_dimension_point_1,lower_dimension_point_2,
lower_dimension_point_3)]).
%--------------------------------------------------------------------------
