%--------------------------------------------------------------------------
% File     : GEO011=AxPtsNotColl-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : The axiom set points are not collinear
% Version  : [Quaife, 1989] axioms : Reduced & Augmented > Complete.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [ANL]
% Names    : T11 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   61 (   6 non-Horn)(   8 unit)
%            Number of literals          :  151 (  75 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    9 (   3 constant)
%            Number of variables         :  277 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : Equidistant reformulated to same_distance
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms for colinearity 
include('Axioms/GEO002-1.ax').
include('Axioms/GEO002-1.eq').
%--------------------------------------------------------------------------
%----A1 - Reflexivity axiom for equidistance 
input_clause(reflexivity_for_equidistance,axiom,
    [++equal_distance(distance(X,Y),distance(Y,X))]).

%----A2 - Transitivity axiom for equidistance 
input_clause(transitivity_for_equidistance,axiom,
    [--equal_distance(distance(X,Y),distance(Z,V)),
     --equal_distance(distance(X,Y),distance(V2,W)),
     ++equal_distance(distance(Z,V),distance(V2,W))]).

%----A3 Indentity axiom for equidistance 
input_clause(identity_for_equidistance,axiom,
    [--equal_distance(distance(X,Y),distance(Z,Z)),
     ++equal(X,Y)]).

%----A4 - Segment construction axiom, two clauses.
%----A4.1 
input_clause(segment_construction1,axiom,
    [++between(X,Y,extension(X,Y,W,V))]).

%----A4.2 
input_clause(segment_construction2,axiom,
    [++equal_distance(distance(Y,extension(X,Y,W,V)),distance(W,V))]).

%----A5 - Outer five-segment axiom 
input_clause(outer_five_segment,axiom,
    [--equal_distance(distance(X,Y),distance(X1,Y1)),
     --equal_distance(distance(Y,Z),distance(Y1,Z1)),
     --equal_distance(distance(X,V),distance(X1,V1)),
     --equal_distance(distance(Y,V),distance(Y1,V1)),
     --between(X,Y,Z),
     --between(X1,Y1,Z1),
     ++equal(X,Y),
     ++equal_distance(distance(Z,V),distance(Z1,V1))]).

%----A6 - Identity axiom for betweenness 
input_clause(identity_for_betweeness,axiom,
    [--between(X,Y,X),
     ++equal(X,Y)]).

%----A7 - Inner Pasch axiom, two clauses. 
%----A7.1 
input_clause(inner_pasch1,axiom,
    [--between(U,V,W),
     --between(Y,X,W),
     ++between(V,inner_pasch(U,V,W,X,Y),Y)]).

%----A7.2 
input_clause(inner_pasch2,axiom,
    [--between(U,V,W),
     --between(Y,X,W),
     ++between(X,inner_pasch(U,V,W,X,Y),U)]).

%----A8 - Lower dimension axiom, three clauses. A8.1 
input_clause(lower_dimension1,axiom,
    [--between(lower_dimension_point_1,lower_dimension_point_2,
lower_dimension_point_3)]).

%----A8.2 
input_clause(lower_dimension2,axiom,
    [--between(lower_dimension_point_2,lower_dimension_point_3,
lower_dimension_point_1)]).

%----A8.3 
input_clause(lower_dimension3,axiom,
    [--between(lower_dimension_point_3,lower_dimension_point_1,
lower_dimension_point_2)]).

%----A9 - Upper dimension axiom 
input_clause(upper_dimension,axiom,
    [--equal_distance(distance(X,W),distance(X,V)),
     --equal_distance(distance(Y,W),distance(Y,V)),
     --equal_distance(distance(Z,W),distance(Z,V)),
     ++between(X,Y,Z),
     ++between(Y,Z,X),
     ++between(Z,X,Y),
     ++equal(W,V)]).

%----A10 - Euclid's axiom, three clauses.
%----A10.1 
input_clause(euclid1,axiom,
    [--between(U,W,Y),
     --between(V,W,X),
     ++equal(U,W),
     ++between(U,V,euclid1(U,V,W,X,Y))]).

%----A10.2 
input_clause(euclid2,axiom,
    [--between(U,W,Y),
     --between(V,W,X),
     ++equal(U,W),
     ++between(U,X,euclid2(U,V,W,X,Y))]).

%----A10.3 
input_clause(euclid3,axiom,
    [--between(U,W,Y),
     --between(V,W,X),
     ++equal(U,W),
     ++between(euclid1(U,V,W,X,Y),Y,euclid2(U,V,W,X,Y))]).

%----A11 - Weakened continuity axiom, two clauses.
%----A11.1 
input_clause(continuity1,axiom,
    [--equal_distance(distance(U,V),distance(U,V1)),
     --equal_distance(distance(U,X),distance(U,X1)),
     --between(U,V,X),
     --between(V,W,X),
     ++between(V1,continuous(U,V,V1,W,X,X1),X1)]).

%----A11.2 
input_clause(continuity2,axiom,
    [--equal_distance(distance(U,V),distance(U,V1)),
     --equal_distance(distance(U,X),distance(U,X1)),
     --between(U,V,X),
     --between(V,W,X),
     ++equal_distance(distance(U,W),distance(U,continuous(U,V,V1,W,X,X1)))]).

%----Equality substitution axioms 
input_clause(distance_substitution1,axiom,
    [--equal(A,B),
     ++equal(distance(A,C),distance(B,C))]).

input_clause(distance_substitution2,axiom,
    [--equal(D,E),
     ++equal(distance(F,D),distance(F,E))]).

input_clause(between_substitution1,axiom,
    [--equal(X,Y),
     --between(X,W,Z),
     ++between(Y,W,Z)]).

input_clause(between_substitution2,axiom,
    [--equal(X,Y),
     --between(W,X,Z),
     ++between(W,Y,Z)]).

input_clause(between_substitution3,axiom,
    [--equal(X,Y),
     --between(W,Z,X),
     ++between(W,Z,Y)]).

input_clause(equal_distance_substitution1,axiom,
    [--equal(X,Y),
     --equal_distance(X,Z),
     ++equal_distance(Y,Z)]).

input_clause(equal_distance_substitution2,axiom,
    [--equal(X,Y),
     --equal_distance(Z,X),
     ++equal_distance(Z,Y)]).

input_clause(inner_pasch_substitution1,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(X,V1,V2,V3,V4),inner_pasch(Y,V1,V2,V3,V4))]).

input_clause(inner_pasch_substitution2,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,X,V2,V3,V4),inner_pasch(V1,Y,V2,V3,V4))]).

input_clause(inner_pasch_substitution3,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,V2,X,V3,V4),inner_pasch(V1,V2,Y,V3,V4))]).

input_clause(inner_pasch_substitution4,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,V2,V3,X,V4),inner_pasch(V1,V2,V3,Y,V4))]).

input_clause(inner_pasch_substitution5,axiom,
    [--equal(X,Y),
     ++equal(inner_pasch(V1,V2,V3,V4,X),inner_pasch(V1,V2,V3,V4,Y))]).

input_clause(euclid1_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(euclid1(A,C,D,E,F),euclid1(B,C,D,E,F))]).

input_clause(euclid1_substitutivity2,axiom,
    [--equal(G,H),
     ++equal(euclid1(I,G,J,K,L),euclid1(I,H,J,K,L))]).

input_clause(euclid1_substitutivity3,axiom,
    [--equal(M,N),
     ++equal(euclid1(O,P,M,Q,R),euclid1(O,P,N,Q,R))]).

input_clause(euclid1_substitutivity4,axiom,
    [--equal(S,T),
     ++equal(euclid1(U,V,W,S,X),euclid1(U,V,W,T,X))]).

input_clause(euclid1_substitutivity5,axiom,
    [--equal(Y,Z),
     ++equal(euclid1(A1,B1,C1,D1,Y),euclid1(A1,B1,C1,D1,Z))]).

input_clause(euclid2_substitutivity1,axiom,
    [--equal(E1,F1),
     ++equal(euclid2(E1,G1,H1,I1,J1),euclid2(F1,G1,H1,I1,J1))]).

input_clause(euclid2_substitutivity2,axiom,
    [--equal(K1,L1),
     ++equal(euclid2(M1,K1,N1,O1,P1),euclid2(M1,L1,N1,O1,P1))]).

input_clause(euclid2_substitutivity3,axiom,
    [--equal(Q1,R1),
     ++equal(euclid2(S1,T1,Q1,U1,V1),euclid2(S1,T1,R1,U1,V1))]).

input_clause(euclid2_substitutivity4,axiom,
    [--equal(W1,X1),
     ++equal(euclid2(Y1,Z1,A2,W1,B2),euclid2(Y1,Z1,A2,X1,B2))]).

input_clause(euclid2_substitutivity5,axiom,
    [--equal(C2,D2),
     ++equal(euclid2(E2,F2,G2,H2,C2),euclid2(E2,F2,G2,H2,D2))]).

input_clause(extend_substitution1,axiom,
    [--equal(X,Y),
     ++equal(extension(X,V1,V2,V3),extension(Y,V1,V2,V3))]).

input_clause(extend_substitution2,axiom,
    [--equal(X,Y),
     ++equal(extension(V1,X,V2,V3),extension(V1,Y,V2,V3))]).

input_clause(extend_substitution3,axiom,
    [--equal(X,Y),
     ++equal(extension(V1,V2,X,V3),extension(V1,V2,Y,V3))]).

input_clause(extend_substitution4,axiom,
    [--equal(X,Y),
     ++equal(extension(V1,V2,V3,X),extension(V1,V2,V3,Y))]).

input_clause(continuity_substitution1,axiom,
    [--equal(X,Y),
     ++equal(continuous(X,V1,V2,V3,V4,V5),
continuous(Y,V1,V2,V3,V4,V5))]).

input_clause(continuity_substitution2,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,X,V2,V3,V4,V5),
continuous(V1,Y,V2,V3,V4,V5))]).

input_clause(continuity_substitution3,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,V2,X,V3,V4,V5),
continuous(V1,V2,Y,V3,V4,V5))]).

input_clause(continuity_substitution4,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,V2,V3,X,V4,V5),
continuous(V1,V2,V3,Y,V4,V5))]).

input_clause(continuity_substitution5,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,V2,V3,V4,X,V5),
continuous(V1,V2,V3,V4,Y,V5))]).

input_clause(continuity_substitution6,axiom,
    [--equal(X,Y),
     ++equal(continuous(V1,V2,V3,V4,V5,X),
continuous(V1,V2,V3,V4,V5,Y))]).

input_clause(prove_lower_dimension_points_not_colinear,theorem,
    [++colinear(lower_dimension_point_1,lower_dimension_point_2,
lower_dimension_point_3)]).
%--------------------------------------------------------------------------
