%--------------------------------------------------------------------------
% File     : GEO011=AxPtsNotColl-1 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Geometry
% Problem  : The axiom set points are not collinear
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
% Source   : [ANL]
% Names    : T11 [McCharen, et al., 1976]
%          : t11.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   63 (   7 non-Horn)(   8 unit)
%            Number of literals          :  161 (  74 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    8 (   3 constant)
%            Number of variables         :  293 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
% Bugfixes : v1.0.1 - Bug in GEO001-0.eq fixed.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO001-0.ax').
include('Axioms/GEO001-0.eq').
%----Include Tarski geometry axioms for colinearity 
include('Axioms/GEO001-1.ax').
include('Axioms/GEO001-1.eq').
%--------------------------------------------------------------------------
input_clause(prove_lower_dimension_points_not_colinear,theorem,
    [++colinear(lower_dimension_point_1,lower_dimension_point_2,
lower_dimension_point_3)]).
%--------------------------------------------------------------------------
