%--------------------------------------------------------------------------
% File     : GEO010=CollInvar-1 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Geometry
% Problem  : Collinearity is invariant
% Version  : [McCharen, et al., 1976] axioms.
% English  : For all points x, y, and z, if x, y, and z are collinear 
%            in one order, they are collinear in any order.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
% Source   : [ANL]
% Names    : T10 [McCharen, et al., 1976]
%          : t10.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   64 (   7 non-Horn)(   8 unit)
%            Number of literals          :  166 (  74 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   11 (   6 constant)
%            Number of variables         :  293 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
% Bugfixes : v1.0.1 - Bug in GEO001-0.eq fixed.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO001-0.ax').
include('Axioms/GEO001-0.eq').
%----Include Tarski geometry axioms for colinearity 
include('Axioms/GEO001-1.ax').
include('Axioms/GEO001-1.eq').
%--------------------------------------------------------------------------
input_clause(abc_colinear,hypothesis,
    [++colinear(a,b,c)]).

input_clause(prove_colinear_in_all_orders,theorem,
    [--colinear(a,c,b),
     --colinear(b,a,c),
     --colinear(b,c,a),
     --colinear(c,a,b),
     --colinear(c,b,a)]).
%--------------------------------------------------------------------------
