%--------------------------------------------------------------------------
% File     : GEO009=1stInrConn-1 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Geometry
% Problem  : First inner connectivity property of betweenness
% Version  : [McCharen, et al., 1976] axioms.
% English  : For all points x, y, z, and w, if y and w are between x and 
%            z, then either y is between x and w or w is between x and y.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
% Source   : [ANL]
% Names    : T9 [McCharen, et al., 1976]
%          : t9.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   59 (   6 non-Horn)(  11 unit)
%            Number of literals          :  145 (  71 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   12 (   7 constant)
%            Number of variables         :  269 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
% Bugfixes : v1.0.1 - Bug in GEO001-0.eq fixed.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO001-0.ax').
include('Axioms/GEO001-0.eq').
%--------------------------------------------------------------------------
input_clause(c_between_a_and_e,hypothesis,
    [++between(a,c,e)]).

input_clause(d_between_a_and_e,hypothesis,
    [++between(a,d,e)]).

input_clause(c_between_a_and_d,hypothesis,
    [--between(a,c,d)]).

input_clause(prove_d_between_a_and_c,theorem,
    [--between(a,d,c)]).
%--------------------------------------------------------------------------
