%--------------------------------------------------------------------------
% File     : GEO008=Btwn5Pts-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Betweenness for 5 points on a line (Five point theorem)
% Version  : [Quaife, 1989] axioms.
% English  : For all points x, y, z, w, and v, if y and w are between 
%            x and z, and v is between y and w, then v is between x and z.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : T8 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   57 (   5 non-Horn)(  11 unit)
%            Number of literals          :  137 (  70 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   13 (   8 constant)
%            Number of variables         :  261 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(c_between_a_and_e,hypothesis,
    [++between(a,c,e)]).

input_clause(d_between_a_and_e,hypothesis,
    [++between(a,d,e)]).

input_clause(b_between_c_and_d,hypothesis,
    [++between(c,b,d)]).

input_clause(prove_betweenness,theorem,
    [--between(a,b,e)]).
%--------------------------------------------------------------------------
