%--------------------------------------------------------------------------
% File     : GEO008=Btwn5Pts-1 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Geometry
% Problem  : Betweenness for 5 points on a line (Five point theorem)
% Version  : [McCharen, et al., 1976] axioms.
% English  : For all points x, y, z, w, and v, if y and w are between 
%            x and z, and v is between y and w, then v is between x and z.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
% Source   : [ANL]
% Names    : T8 [McCharen, et al., 1976]
%          : Test Problem 10 [Wos, 1988]
%          : The Five Point Theorem [Wos, 1988]
%          : t8.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   59 (   6 non-Horn)(  11 unit)
%            Number of literals          :  145 (  71 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   13 (   8 constant)
%            Number of variables         :  269 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
% Bugfixes : v1.0.1 - Bug in GEO001-0.eq fixed.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO001-0.ax').
include('Axioms/GEO001-0.eq').
%--------------------------------------------------------------------------
input_clause(c_between_a_and_e,hypothesis,
    [++between(a,c,e)]).

input_clause(d_between_a_and_e,hypothesis,
    [++between(a,d,e)]).

input_clause(b_between_c_and_d,hypothesis,
    [++between(c,b,d)]).

input_clause(prove_betweenness,theorem,
    [--between(a,b,e)]).
%--------------------------------------------------------------------------
