%--------------------------------------------------------------------------
% File     : GEO007=Btwn4Pts-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Betweenness for 4 points on a line
% Version  : [Quaife, 1989] axioms.
% English  : For all pairs of distinct points y and z, if w and x are 
%            on the line yz to the left of y (i.e. not between y and z), 
%            then either w is betweeen x and y or x is between w and y.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : T7 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   58 (   5 non-Horn)(  12 unit)
%            Number of literals          :  138 (  71 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   12 (   7 constant)
%            Number of variables         :  261 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(a_not_c,hypothesis,
    [--equal(a,c)]).

input_clause(a_between_a_and_c,hypothesis,
    [++between(d,a,c)]).

input_clause(a_between_a_and_e,hypothesis,
    [++between(e,a,c)]).

input_clause(e_not_between_d_and_a,hypothesis,
    [--between(d,e,a)]).

input_clause(prove_d_between_e_and_a,theorem,
    [--between(e,d,a)]).
%--------------------------------------------------------------------------
