%--------------------------------------------------------------------------
% File     : GEO006=Btwn3Pts-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Betweenness for 3 points on a line
% Version  : [Quaife, 1989] axioms.
% English  : For any three distinct points x, y, and z, if y is between 
%            x and z, then both x is not between y and z and z is not 
%            between x and y.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : T6 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   58 (   6 non-Horn)(  11 unit)
%            Number of literals          :  139 (  73 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (   6 constant)
%            Number of variables         :  261 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : This presentation may have alternatives/be incorrect.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(a_not_c,hypothesis,
    [--equal(a,c)]).

input_clause(a_not_d,hypothesis,
    [--equal(a,d)]).

input_clause(c_not_d,hypothesis,
    [--equal(c,d)]).

input_clause(c_between_a_and_d,hypothesis,
    [++between(a,c,d)]).

input_clause(prove_not_between_others,theorem,
    [++between(c,a,d),
     ++between(a,d,c)]).
%--------------------------------------------------------------------------
